function vB_AJAX_TagSuggest(varname, textobjid, menukey)
{
	var webkit_version = userAgent.match(/applewebkit\/([0-9]+)/);

	if (AJAX_Compatible && !(is_saf && !(webkit_version[1] >= 412)))
	{
		this.menuobj = fetch_object(menukey + '_menu');
		this.textobj = fetch_object(textobjid);
		this.textobj.setAttribute("autocomplete", "off");
		this.textobj.onfocus = function(e) { this.obj.active = true; };
		this.textobj.onblur  = function(e) { this.obj.active = false; };
		this.textobj.obj = this;

		this.varname = varname;
		this.menukey = menukey;
		this.fragment = '';
		this.donetags = '';
		this.delimiters = new Array(',');
		this.selected = 0;
		this.menuopen = false;
		this.timeout = null;
		this.tags = new Array();
		this.active = false;
		this.ajax_req = null;

		this.allow_multiple = false;
		this.min_chars = 3;

		this.set_delimiters = function(delimiters)
		{
			this.delimiters = new Array(',');

			if (delimiters)
			{
				var delim_matches, i;

				if (delim_matches = PHP.match_all(delimiters, '\{([^}]*)\}'))
				{
					for (i = 0; i < delim_matches.length; i++)
					{
						if (delim_matches[i][1] !== '')
						{
							this.delimiters.push(delim_matches[i][1]);
						}

						delimiters = delimiters.replace(delim_matches[i][0], '');
					}
				}

				delim_matches = delimiters.split(' ');
				for (i = 0; i < delim_matches.length; i++)
				{
					if (delim_matches[i] !== '')
					{
						this.delimiters.push(delim_matches[i]);
					}
				}
			}
		}

		this.get_text = function()
		{
			if (this.allow_multiple)
			{
				var delimpos = -1, delimlen;
				for (var delimid = 0; delimid < this.delimiters.length; delimid++)
				{
					if (this.textobj.value.lastIndexOf(this.delimiters[delimid]) > delimpos)
					{
						delimpos = this.textobj.value.lastIndexOf(this.delimiters[delimid]);
						delimlen = this.delimiters[delimid].length;
					}
				}

				if (delimpos == -1)
				{
					this.donetags = new String('');
					this.fragment = new String(this.textobj.value);
				}
				else
				{
					this.donetags = new String(this.textobj.value.substring(0, delimpos + delimlen));
					this.fragment = new String(this.textobj.value.substring(delimpos + delimlen));
				}
			}
			else
			{
				this.fragment = new String(this.textobj.value);
			}

			this.fragment = PHP.trim(this.fragment);
		}

		this.set_text = function(i)
		{
			if (this.allow_multiple)
			{
				var extra_space = (this.donetags.substr(this.donetags.length - 1) == " " ? "" : " ");
				this.textobj.value = PHP.ltrim(this.donetags + extra_space + PHP.unhtmlspecialchars(this.tags[i]) + ", ");
			}
			else
			{
				this.textobj.value = PHP.unhtmlspecialchars(this.tags[i]);
			}

			this.textobj.focus();

			this.menu_hide();

			return false;
		}

		this.move_row_selection = function(increment)
		{
			var newval = parseInt(this.selected, 10) + parseInt(increment, 10);

			if (newval < 0)
			{
				newval = this.tags.length - 1;
			}
			else if (newval >= this.tags.length)
			{
				newval = 0;
			}

			this.set_row_selection(newval);

			return false;
		}

		this.set_row_selection = function(i)
		{
			var tds = fetch_tags(this.menuobj, 'td');
			tds[this.selected].className = 'vbmenu_option';
			this.selected = i;
			tds[this.selected].className = 'vbmenu_hilite';
		}

		this.key_event_handler = function(evt)
		{
			evt = evt ? evt : window.event;

			if (this.menuopen)
			{
				switch (evt.keyCode)
				{
					case 38: // arrow up
					{
						this.move_row_selection(-1);
						return false;
					}
					case 40: // arrow down
					{
						this.move_row_selection(1);
						return false;
					}
					case 27: // escape
					{
						this.menu_hide();
						return false;
					}
					case 13: // return / enter
					{
						this.set_text(this.selected);
						return false;
					}
				}
			}

			this.get_text();

			if (this.fragment.length >= this.min_chars)
			{
				clearTimeout(this.timeout);
				this.timeout = setTimeout(this.varname + '.tag_search();', 500);
			}
			else
			{
				this.menu_hide();
			}
		}

		this.tag_search = function()
		{
			if (this.active)
			{
				this.tags = new Array();

				this.ajax_req = YAHOO.util.Connect.asyncRequest("POST", "umg_ajax.php?do=tagsearch", {
					success: this.handle_ajax_response,
					failure: vBulletin_AJAX_Error_Handler,
					timeout: vB_Default_Timeout,
					scope: this
				}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=tagsearch&fragment=" + PHP.urlencode(this.fragment));
			}
		}

		this.handle_ajax_response = function(ajax)
		{
			if (ajax.responseXML)
			{
				var node = this.textobj;
				do
				{
					if (node.style.display == 'none')
					{
						this.menu_hide();
						return;
					}
				}
				while ((node = node.parentNode) != null && node.style);

				var tags = ajax.responseXML.getElementsByTagName('tag');
				if (tags.length)
				{
					for (var i = 0; i < tags.length; i++)
					{
						this.tags[i] = tags[i].firstChild.nodeValue;
					}
				}

				if (this.tags.length)
				{
					this.menu_build();
					this.menu_show();
				}
				else
				{
					this.menu_hide();
				}
			}
		}

		this.menu_build = function()
		{
			this.menu_empty();
			var re = new RegExp('^(' + PHP.preg_quote(this.fragment) + ')', "i");

			var table = document.createElement('table');
			table.cellPadding = 4;
			table.cellSpacing = 1;
			table.border = 0;
			for (var i in this.tags)
			{
				if (YAHOO.lang.hasOwnProperty(this.tags, i))
				{
					var td = table.insertRow(-1).insertCell(-1);
					td.className = (i == this.selected ? 'vbmenu_hilite' : 'vbmenu_option');
					td.title = 'nohilite';
					td.innerHTML = '<a onclick="return ' + this.varname + '.set_text(' + i + ')">' + this.tags[i].replace(re, '<strong>$1</strong>') + '</a>';
				}
			}
			this.menuobj.appendChild(table);

			if (this.vbmenu == null)
			{
				if (typeof(vBmenu.menus[this.menukey]) != 'undefined')
				{
					this.vbmenu = vBmenu.menus[this.menukey];
				}
				else
				{
					this.vbmenu = vBmenu.register(this.menukey, true);
				}
			}
			else
			{
				this.vbmenu.init_menu_contents();
			}
		}

		this.menu_empty = function()
		{
			this.selected = 0;

			while (this.menuobj.firstChild)
			{
				this.menuobj.removeChild(this.menuobj.firstChild);
			}
		}

		this.menu_show = function()
		{
			if (this.active && fetch_object(this.menukey))
			{
				this.vbmenu.show(fetch_object(this.menukey), this.menuopen);
				this.menuopen = true;
			}
		}

		this.menu_hide = function()
		{
			try
			{
				this.vbmenu.hide();
			}
			catch(e) {}
			this.menuopen = false;
		}

		this.textobj.onkeyup = function(e) { return this.obj.key_event_handler(e); };
		this.textobj.onkeypress = function(e)
		{
			e = e ? e : window.event;
			if (e.keyCode == 13)
			{
				return (this.obj.menuopen ? false : true);
			}
		};
	}
	else
	{
		this.set_delimiters = function(delimiters) 
		{
		}
	}
}
